/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine;

import com.google.common.collect.Lists;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.architectury.utils.EnvExecutor;
import dev.architectury.utils.value.IntValue;
import dev.ftb.mods.ftbultimine.BrokenItemHandler;
import dev.ftb.mods.ftbultimine.FTBUltimineCommon;
import dev.ftb.mods.ftbultimine.FTBUltiminePlayerData;
import dev.ftb.mods.ftbultimine.ItemCollection;
import dev.ftb.mods.ftbultimine.client.FTBUltimineClient;
import dev.ftb.mods.ftbultimine.config.FTBUltimineCommonConfig;
import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import dev.ftb.mods.ftbultimine.integration.FTBUltiminePlugins;
import dev.ftb.mods.ftbultimine.net.FTBUltimineNet;
import dev.ftb.mods.ftbultimine.net.SendShapePacket;
import dev.ftb.mods.ftbultimine.shape.BlockMatcher;
import dev.ftb.mods.ftbultimine.shape.EscapeTunnelShape;
import dev.ftb.mods.ftbultimine.shape.MiningTunnelShape;
import dev.ftb.mods.ftbultimine.shape.Shape;
import dev.ftb.mods.ftbultimine.shape.ShapeContext;
import dev.ftb.mods.ftbultimine.shape.ShapelessShape;
import dev.ftb.mods.ftbultimine.shape.SmallSquareShape;
import dev.ftb.mods.ftbultimine.shape.SmallTunnelShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FTBUltimine {
    public static FTBUltimine instance;
    public static final String MOD_ID = "ftbultimine";
    public static final Logger LOGGER;
    public final FTBUltimineCommon proxy;
    private Map<UUID, FTBUltiminePlayerData> cachedDataMap;
    private boolean isBreakingBlock;
    private int tempBlockDroppedXp;
    private ItemCollection tempBlockDropsList;
    public static final TagKey<Item> DENY_TAG;
    public static final TagKey<Item> STRICT_DENY_TAG;
    public static final TagKey<Item> ALLOW_TAG;
    public static final TagKey<Block> EXCLUDED_BLOCKS;
    private static Predicate<Player> permissionOverride;

    public static void setPermissionOverride(Predicate<Player> p) {
        permissionOverride = p;
    }

    public FTBUltimine() {
        instance = this;
        FTBUltimineNet.init();
        this.proxy = (FTBUltimineCommon)EnvExecutor.getEnvSpecific(() -> FTBUltimineClient::new, () -> FTBUltimineCommon::new);
        FTBUltimineCommonConfig.load();
        FTBUltiminePlugins.init();
        Shape.register(new ShapelessShape());
        Shape.register(new SmallTunnelShape());
        Shape.register(new SmallSquareShape());
        Shape.register(new MiningTunnelShape());
        Shape.register(new EscapeTunnelShape());
        Shape.postinit();
        LifecycleEvent.SERVER_BEFORE_START.register(this::serverStarting);
        BlockEvent.BREAK.register(this::blockBroken);
        InteractionEvent.RIGHT_CLICK_BLOCK.register(this::blockRightClick);
        TickEvent.PLAYER_PRE.register(this::playerTick);
        EntityEvent.ADD.register(this::entityJoinedWorld);
    }

    public FTBUltiminePlayerData get(Player player) {
        return this.cachedDataMap.computeIfAbsent(player.m_142081_(), FTBUltiminePlayerData::new);
    }

    private void serverStarting(MinecraftServer server) {
        this.cachedDataMap = new HashMap<UUID, FTBUltiminePlayerData>();
        FTBUltimineServerConfig.load(server);
    }

    public void setKeyPressed(ServerPlayer player, boolean pressed) {
        FTBUltiminePlayerData data = this.get((Player)player);
        data.pressed = pressed;
        data.clearCache();
        if (!data.pressed) {
            new SendShapePacket(data.shape, Collections.emptyList()).sendTo(player);
        }
    }

    public void modeChanged(ServerPlayer player, boolean next) {
        FTBUltiminePlayerData data = this.get((Player)player);
        data.shape = next ? data.shape.next : data.shape.prev;
        data.clearCache();
        new SendShapePacket(data.shape, Collections.emptyList()).sendTo(player);
    }

    private int getMaxBlocks(Player player) {
        return (Integer)FTBUltimineServerConfig.MAX_BLOCKS.get();
    }

    public static boolean isValidTool(Item mainHand, Item offHand) {
        if (mainHand.m_204114_().m_203656_(STRICT_DENY_TAG) || offHand.m_204114_().m_203656_(STRICT_DENY_TAG)) {
            return false;
        }
        if (mainHand.m_204114_().m_203656_(DENY_TAG)) {
            return false;
        }
        ArrayList allowedTools = Lists.newArrayList((Iterable)Registry.f_122827_.m_206058_(ALLOW_TAG));
        Holder mainHandHolder = Holder.m_205709_((Object)mainHand);
        if (((Boolean)FTBUltimineCommonConfig.REQUIRE_TOOL.get()).booleanValue()) {
            if (mainHand == Items.f_41852_) {
                return false;
            }
            return mainHand instanceof TieredItem || mainHand.m_41462_() > 0 || allowedTools.contains(mainHandHolder);
        }
        return allowedTools.isEmpty() || allowedTools.contains(mainHandHolder);
    }

    public boolean canUltimine(Player player) {
        Item offHand;
        if (PlayerHooks.isFake((Player)player) || player.m_142081_() == null) {
            return false;
        }
        if (player.m_36324_().m_38702_() <= 0 && !player.m_7500_()) {
            return false;
        }
        if (!permissionOverride.test(player)) {
            return false;
        }
        Item mainHand = player.m_21205_().m_41720_();
        return FTBUltimine.isValidTool(mainHand, offHand = player.m_21206_().m_41720_()) && FTBUltiminePlugins.canUltimine(player);
    }

    public EventResult blockBroken(Level world, BlockPos pos, BlockState state, ServerPlayer player, @Nullable IntValue xp) {
        if (this.isBreakingBlock || !this.canUltimine((Player)player)) {
            return EventResult.pass();
        }
        FTBUltiminePlayerData data = this.get((Player)player);
        if (!data.pressed) {
            return EventResult.pass();
        }
        HitResult result = FTBUltiminePlayerData.rayTrace(player);
        if (!(result instanceof BlockHitResult) || result.m_6662_() != HitResult.Type.BLOCK) {
            return EventResult.pass();
        }
        data.clearCache();
        data.updateBlocks(player, pos, ((BlockHitResult)result).m_82434_(), false, this.getMaxBlocks((Player)player));
        if (data.cachedBlocks == null || data.cachedBlocks.isEmpty()) {
            return EventResult.pass();
        }
        this.isBreakingBlock = true;
        this.tempBlockDropsList = new ItemCollection();
        this.tempBlockDroppedXp = 0;
        boolean hadItem = !player.m_21205_().m_41619_();
        for (BlockPos p : data.cachedBlocks) {
            if (!player.f_8941_.m_9280_(p) && ((Boolean)FTBUltimineCommonConfig.CANCEL_ON_BLOCK_BREAK_FAIL.get()).booleanValue()) break;
            if (!player.m_7500_()) {
                player.m_36399_((float)((Double)FTBUltimineServerConfig.EXHAUSTION_PER_BLOCK.get() * 0.005));
                if (player.m_36324_().m_38702_() <= 0) break;
            }
            ItemStack stack = player.m_21205_();
            if (!(hadItem && stack.m_41619_() || hadItem && stack.m_41782_() && stack.m_41783_().m_128471_("tic_broken")) && (!hadItem || (Integer)FTBUltimineCommonConfig.PREVENT_TOOL_BREAK.get() <= 0 || !stack.m_41763_() || stack.m_41773_() < stack.m_41776_() - (Integer)FTBUltimineCommonConfig.PREVENT_TOOL_BREAK.get())) continue;
            break;
        }
        this.isBreakingBlock = false;
        this.tempBlockDropsList.drop(player.f_19853_, pos);
        if (this.tempBlockDroppedXp > 0) {
            player.f_19853_.m_7967_((Entity)new ExperienceOrb(player.f_19853_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, this.tempBlockDroppedXp));
        }
        data.clearCache();
        new SendShapePacket(data.shape, Collections.emptyList()).sendTo(player);
        return EventResult.interruptFalse();
    }

    public EventResult blockRightClick(Player player, InteractionHand hand, BlockPos clickPos, Direction face) {
        if (!(player instanceof ServerPlayer) || PlayerHooks.isFake((Player)player) || player.m_142081_() == null) {
            return EventResult.pass();
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (player.m_36324_().m_38702_() <= 0 && !player.m_7500_()) {
            return EventResult.pass();
        }
        HitResult result = FTBUltiminePlayerData.rayTrace(serverPlayer);
        if (!(result instanceof BlockHitResult) || result.m_6662_() != HitResult.Type.BLOCK) {
            return EventResult.pass();
        }
        FTBUltiminePlayerData data = this.get(player);
        data.clearCache();
        ShapeContext shapeContext = data.updateBlocks(serverPlayer, clickPos, ((BlockHitResult)result).m_82434_(), false, this.getMaxBlocks(player));
        if (shapeContext == null || !data.pressed || data.cachedBlocks == null || data.cachedBlocks.isEmpty()) {
            return EventResult.pass();
        }
        if (player.m_21120_(hand).m_41720_() instanceof HoeItem) {
            ResourceLocation dirtTag = new ResourceLocation(MOD_ID, "farmland_tillable");
            TagKey dirtKey = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)dirtTag);
            if (!player.f_19853_.m_5776_()) {
                boolean playSound = false;
                BrokenItemHandler brokenItemHandler = new BrokenItemHandler();
                for (int i = 0; i < Math.min(data.cachedBlocks.size(), (Integer)FTBUltimineServerConfig.MAX_BLOCKS.get()); ++i) {
                    BlockPos p = data.cachedBlocks.get(i);
                    BlockState state = player.f_19853_.m_8055_(p);
                    if (!state.m_204336_(dirtKey)) continue;
                    player.f_19853_.m_7731_(p, Blocks.f_50093_.m_49966_(), 11);
                    playSound = true;
                    if (player.m_7500_()) continue;
                    player.m_21205_().m_41622_(1, (LivingEntity)serverPlayer, (Consumer)brokenItemHandler);
                    player.m_36399_((float)((Double)FTBUltimineServerConfig.EXHAUSTION_PER_BLOCK.get() * 0.005));
                    if (brokenItemHandler.isBroken || player.m_36324_().m_38702_() <= 0) break;
                }
                if (playSound) {
                    player.f_19853_.m_5594_(player, clickPos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
            player.m_6674_(hand);
            return EventResult.interruptFalse();
        }
        if (shapeContext.matcher == BlockMatcher.BUSH) {
            ItemCollection itemCollection = new ItemCollection();
            for (BlockPos pos : data.cachedBlocks) {
                CropBlock c;
                BlockState state = player.f_19853_.m_8055_(pos);
                if (!(state.m_60734_() instanceof CropBlock) || !(c = (CropBlock)state.m_60734_()).m_52307_(state)) continue;
                if (player.f_19853_.m_5776_()) {
                    player.m_6674_(hand);
                    continue;
                }
                List drops = Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)player.f_19853_), (BlockPos)pos, (BlockEntity)(state.m_155947_() ? player.f_19853_.m_7702_(pos) : null), (Entity)player, (ItemStack)ItemStack.f_41583_);
                for (ItemStack stack : drops) {
                    if (Block.m_49814_((Item)stack.m_41720_()) == c) {
                        stack.m_41774_(1);
                    }
                    itemCollection.add(stack);
                }
                player.f_19853_.m_7731_(pos, c.m_52289_(0), 3);
            }
            itemCollection.drop(player.f_19853_, face == null ? clickPos : clickPos.m_142300_(face));
            player.m_6674_(hand);
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public void playerTick(Player player) {
        if (!player.f_19853_.m_5776_()) {
            FTBUltiminePlayerData data = this.get(player);
            data.checkBlocks((ServerPlayer)player, true, this.getMaxBlocks(player));
        }
    }

    public EventResult entityJoinedWorld(Entity entity, Level level) {
        if (this.isBreakingBlock && entity instanceof ItemEntity) {
            this.tempBlockDropsList.add(((ItemEntity)entity).m_32055_());
            return EventResult.interruptFalse();
        }
        if (this.isBreakingBlock && entity instanceof ExperienceOrb) {
            this.tempBlockDroppedXp += ((ExperienceOrb)entity).m_20801_();
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    static {
        LOGGER = LogManager.getLogger();
        DENY_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(MOD_ID, "excluded_tools"));
        STRICT_DENY_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(MOD_ID, "excluded_tools/strict"));
        ALLOW_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(MOD_ID, "included_tools"));
        EXCLUDED_BLOCKS = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation(MOD_ID, "excluded_blocks"));
        permissionOverride = player -> true;
    }
}

